/*
 * ListList.java
 *
 * Created on 15. August 2003, 21:03
 * 
 * Rolf Wilms ($RWI), 11. Oktober 2003:
 * - Code auf Geschwindigkeit optimiert
 * - Quick&Dirty von Swing auf AWT umgestellt 
 * 
 */

/**
 *
 * @author  Administrator
 */
import java.awt.*;
import java.util.*;

public class AwtOptListList_OOP extends Frame {

	/** Creates new form ListList */
	public AwtOptListList_OOP() {
		super("Java: ListList_OOP");
		initComponents();
		// ListBox an Liste binden
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents() { //GEN-BEGIN:initComponents
		jDialog1 = new Dialog(this);
		setLayout(new BorderLayout(0, 2));
		setBackground(Color.LIGHT_GRAY);
		bCreateTree = new Button();
		bBenchCreate = new Button();
		jScrollPane1 = new ScrollPane();
		listBox1 = new java.awt.List();

		jDialog1.setModal(true);

		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				exitForm(evt);
			}
		});

		bCreateTree.setLabel("bCreateTree (100 Entries)");
		bCreateTree.setSize(new java.awt.Dimension(200, 26));
		bCreateTree.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				bCreateTreeActionPerformed(evt);
			}
		});

		add(bCreateTree, java.awt.BorderLayout.NORTH);

		bBenchCreate.setLabel("bBenchCreate (1 Mio Entries)");
		bBenchCreate.setSize(new java.awt.Dimension(200, 26));
		bBenchCreate.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				bBenchCreateActionPerformed(evt);
			}
		});

		add(bBenchCreate, java.awt.BorderLayout.CENTER);

		jScrollPane1.setSize(new java.awt.Dimension(300, 400));
		jScrollPane1.add(listBox1);

		add(jScrollPane1, java.awt.BorderLayout.SOUTH);
		
		pack();
	} //GEN-END:initComponents

	private void bBenchCreateActionPerformed(java.awt.event.ActionEvent evt) {
		//GEN-FIRST:event_bBenchCreateActionPerformed
		// 1 Million Objekte, 100 Millionen Suchvorgnge
		listBox1.removeAll();

		long fullBench = 0;
		long constructionTime = 0;
		long destructionTime = 0;
		long findTime = 0;
		long meanTime;
		long start = 0;
		ClearList(); // synchron
		start = System.currentTimeMillis();
		for (int x = 1; x <= 10; x++) {
			meanTime = System.currentTimeMillis();
			BuildBaseList(100000);
			constructionTime += (System.currentTimeMillis() - meanTime);
			meanTime = System.currentTimeMillis();
			ShowEntry("Search a: " + FindListEntry(RootDir, "a"));
			ShowEntry("Search ax: " + FindListEntry(RootDir, "ax"));
			ShowEntry("Search axv: " + FindListEntry(RootDir, "axv"));
			ShowEntry("Search axve: " + FindListEntry(RootDir, "axve"));
			for (int y = 1; y <= 20; y++)
				FindListEntry(RootDir, "X"); // gibts nicht
			findTime += (System.currentTimeMillis() - meanTime);

			meanTime = System.currentTimeMillis();
			ClearList();
			destructionTime += (System.currentTimeMillis() - meanTime);
		}
		long diff = System.currentTimeMillis() - start;

		TextArea txt = new TextArea();
		txt.setText(
			"Time:\t\t"
				+ lToTString(diff)
				+ "\nfor Construction:\t"
				+ lToTString(constructionTime)
				+ "\nfor Destruction:\t\t"
				+ lToTString(destructionTime)
				+ "\nfor Find:\t\t"
				+ lToTString(findTime));
		jDialog1 = new Dialog(this);
		jDialog1.setTitle("Java: ListList_OOP");
		jDialog1.setModal(true);
		jDialog1.setBounds(0, 0, 300, 150);
		jDialog1.add("Center", txt);
		jDialog1.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				jDialog1.dispose();
			}
		});
		jDialog1.show();

		//        MessageBox.Show("Time: "+(timeGetTime()-STime).ToString());
	} //GEN-LAST:event_bBenchCreateActionPerformed

	String lToTString(long Millisecs) {
		String std, min, sec, ms;
		std = "0" + Millisecs / 3600000;
		min = "0" + Millisecs % 3600000 / 60000;
		sec = "0" + Millisecs % 60000 / 1000;
		ms = "00" + Millisecs % 1000;

		return std.substring(std.length() - 2)
			+ ":"
			+ min.substring(min.length() - 2)
			+ ":"
			+ sec.substring(sec.length() - 2)
			+ "."
			+ ms.substring(ms.length() - 3);
	}

	private String FindListEntry(SingleEntry List, String SubStr) {
		SingleEntry E = List.FindEntry(SubStr);

		if (E != null)
			return E.FullName();
		else
			return "";
	}

	private void bCreateTreeActionPerformed(java.awt.event.ActionEvent evt) {
		//GEN-FIRST:event_bCreateTreeActionPerformed
		// Demo-Liste mit 100 Elementen, Anzeige
		listBox1.removeAll();

		ClearList();
		BuildBaseList(100);
		PrintListList(RootDir, 1);
		ClearList();

	} //GEN-LAST:event_bCreateTreeActionPerformed

	/** Exit the Application */
	private void exitForm(
		java.awt.event.WindowEvent evt) { //GEN-FIRST:event_exitForm
		System.exit(0);
	} //GEN-LAST:event_exitForm
	void BuildListList(SingleEntry List, int Level) {
		// Listenaufbau (rekursiv)           
		int LocalCount = Rand.nextInt(25) + 1;
		int NameLength;
		String NewName;

		// maximal 25 Eintrge pro Liste - nur das Stammverzeichnis
		// kann mehr haben
		for (int x = 1; x <= LocalCount; x++) {
			EntryCount--;
			// zuflliger Name mit 1-8 Zeichen
			NameLength = Rand.nextInt(8) + 1;

			// $RWI: Schneller als StringBuffer in Instanzvariable ist direkt ein char[] zu benutzen.
			final char[] cBuf = newNameCharBuf;
			for (int y = 0; y < NameLength; y++) {
				cBuf[y] = (char) ((int) 'a' + Rand.nextInt(26));
			}
			NewName = new String(cBuf, 0, NameLength);

			// Einzelner Eintrag oder neue Liste? Die Wahrscheinlichkeit
			// fr neue Listen (und weitere Rekursion) sinkt mit zunehmender
			// Verschachelungstiefe
			if (Rand.nextInt(10 * Level) < 1)
				BuildListList(List.AddNode(NewName), Level + 1);
			else
				List.AddEntry(NewName);

			if (EntryCount <= 0)
				break;
		}
	}

	void ClearList() {
		RootDir = new ListEntry("C:");
		System.gc();
	}

	void BuildBaseList(int ECount) {
		// Legt die Elementenzahl fest und erzeugt das Stammverzeichnis        
		EntryCount = ECount;
		while (EntryCount > 0)
			BuildListList(RootDir, 1);
	}

	void ShowEntry(String S) {
		// Anzeige in der Listbox, auch fr Suchergebnisse        
		listBox1.add(S);
	}

	private void PrintListList(
		SingleEntry List,
		int Level) { // Ausgabe der Demo-Liste (100 Elemente)
		String Lead = "";
		SingleEntry CurEntry;

		for (int x = 1; x < Level; x++)
			Lead = Lead + "  ";

		// EntryName+' (LIST) fr Verzeichnisse
		ShowEntry(Lead + List.GetDisplayName());
		// Dateieintrge und Verzeichnisse, ungeordnet
		CurEntry = List.FirstEntry();
		while (CurEntry != null) {
			PrintListList(CurEntry, Level + 1);
			CurEntry = List.NextEntry(CurEntry);
		}
	}

	// $RWI: Diese Klasse hat keinen Bezug zur ueren Instanz, kann daher static sein.
	// Speicherplatz und Initialisierungszeit der Referenz eingespart.  
	public static class SingleEntry // einzelnes Element
	{
		public String FEntryName;
		protected SingleEntry ParentList; // backtracking

		public SingleEntry(String EName) {
			FEntryName = EName;
		}
		public SingleEntry(String EName, SingleEntry Parent) {
			this(EName);
			ParentList = Parent;
		}

		public String GetDisplayName() {
			return FEntryName;
		}

		public String FullName() {
			if (ParentList != null)
				return ParentList.FullName() + '\\' + FEntryName;
			else
				return FEntryName;
		}

		public SingleEntry FindEntry(String PartialName) {
			// $RWI: Aufruf von equals ist teuer, daher vorher Lnge vergleichen. 
			if (FEntryName.length() == PartialName.length()
				&& FEntryName.equals(PartialName))
				return this; // 5.1
			else
				return null;
		}

		public SingleEntry AddEntry(String EName) {
			return this;
		}

		public SingleEntry AddNode(String NName) {
			return this;
		}

		public SingleEntry FirstEntry() {
			return null;
		}
		public SingleEntry NextEntry(SingleEntry CurEntry) {
			return null;
		}
	}

	// $RWI: Diese Klasse hat keinen Bezug zur ueren Instanz, kann daher static sein.
	// Speicherplatz und Initialisierungszeit der Referenz eingespart.  
	public static class ListEntry extends SingleEntry // Verzeichnis
	{
		// $RWI: ArrayList durch Array plus Lnge ersetzt. 
		// Hier nicht bentigte Flexibilitt von ArrayLists kostet Performance.  
		private SingleEntry[] EntryList = new SingleEntry[25];
		private int entryListSize = 0;
		// SingleEntry und ListEntry gemischt

		public ListEntry(String EName) {
			super(EName);
			// $RWI Initialisierung von EntryList erfolgt als Variableninitialisierer.
		}

		public ListEntry(String EName, SingleEntry Parent) {
			this(EName);
			ParentList = Parent;
		}

		public String GetDisplayName() {
			return FEntryName + " (LIST)";
		}

		public SingleEntry FindEntry(String PartialName) {
			SingleEntry Result = super.FindEntry(PartialName);

			// $RWI Anpassung Zugriff auf Array statt ArrayList 
			if (Result == null) {
				int listSize = entryListSize;
				for (int x = 0; x < listSize; x++) {
					SingleEntry E = EntryList[x];
					Result = E.FindEntry(PartialName);
					if (Result != null)
						break;
				}
			}
			return Result;
		}

		public SingleEntry AddEntry(String EName) {
			SingleEntry Result = new SingleEntry(EName, this);
			// $RWI Anpassung Zugriff auf Array statt ArrayList 
			add(Result);
			return Result;
		}

		public SingleEntry AddNode(String NName) {
			ListEntry Result = new ListEntry(NName, this);
			// $RWI Anpassung Zugriff auf Array statt ArrayList 
			add(Result);
			return Result;
		}

		public SingleEntry FirstEntry() {
			// $RWI Anpassung Zugriff auf Array statt ArrayList 
			if (entryListSize == 0)
				return null;
			else
				return (SingleEntry) EntryList[0];
		}

		public SingleEntry NextEntry(SingleEntry CurEntry) {
			// $RWI Anpassung Zugriff auf Array statt ArrayList 
			int x = indexOf(CurEntry);
			if (x != -1 && x + 1 < entryListSize)
				return (SingleEntry) EntryList[x + 1];
			else
				return null;
		}

		// $RWI Hilfsfunktion fr Zugriff auf Array statt ArrayList 
		private void add(SingleEntry element) {
			// try/catch ist hier schneller als if...
			try {
				EntryList[entryListSize] = element;
			} catch (ArrayIndexOutOfBoundsException e) {
				int len = EntryList.length;
				SingleEntry[] t = new SingleEntry[(int)((long)len * 3 / 2)];
				System.arraycopy(EntryList, 0, t, 0, len);
				EntryList = t;
				EntryList[entryListSize] = element;
			}
			entryListSize++;
		}

		// $RWI Hilfsfunktion fr Zugriff auf Array statt ArrayList 
		private int indexOf(SingleEntry element) {
			for (int i = 0; i < entryListSize; i++) {
				if (EntryList[i].equals(element)) {
					return i;
				}
			}
			return -1;
		}

	}

	// $RWI: LCG mit ANSI C Multiplikator und Offset. Verteilung so schlecht wie bei ANSI C rand(), 
	// aber auch so schnell. 
	public static class AnsiCRandom {
		private int next;

		public AnsiCRandom(int seed) {
			next = seed;
		}

		public int nextInt(int mod) {
			return ((next = next * 1103515245 + 12345) >>> 16) % mod;
		}
	}

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		new AwtOptListList_OOP().show();
	}

	ArrayList showlist = new ArrayList();
	ListEntry RootDir = null; // "Stammverzeichnis"
	int EntryCount; // Runterzhler frs Anlegen der Struktur
	
	// $RWI: Verwende quivalent zu ANSI C rand() Funktion statt Java Random.
	AnsiCRandom Rand = new AnsiCRandom((int)System.currentTimeMillis());

	// $RWI: Hilfspuffer fr Stringkonstruktion
	char[] newNameCharBuf = new char[256];


	// Variables declaration - do not modify//GEN-BEGIN:variables
	private Button bBenchCreate;
	private Button bCreateTree;
	private Dialog jDialog1;
	private ScrollPane jScrollPane1;
	private java.awt.List listBox1;
	// End of variables declaration//GEN-END:variables

}
